set more off
cap log close
clear
set virtual on

log using regression_bootstrap_utilization, replace

*Set paramters
global random_factor=50
global bootreps=200
tempfile basedat rfedat bootdat1 bootdat2


use analytic_file, clear

save "`basedat'", replace


forvalues z=1(1)$bootreps {
local g=`z'*$random_factor
set seed `g'

use "`basedat'", clear
bsample, strata(mcbs msa)

save "`bootdat1'", replace
cap erase "`rfedat'"

display "STARTING ROUND" `z'


foreach i in no_hosp days_hosp outpat_vis rx_30de {
use "`bootdat1'", clear

* Private regressions
qui reg `i' MSA2-MSA99 age age2 male age_male age2_male income income2 dz_2-dz_30 Y2-Y7 if mcbs==0, robust
matrix A=e(V)
* Private coefficient estimates
scalar `i'_e1=0
forvalues ZZ=2(1)99 { 
scalar `i'_e`ZZ'=_b[MSA`ZZ']
}
* Private coefficient variances
scalar `i'_v1=0
for ZZ in num 2/99 \ XX in num 1/98 : scalar `i'_vZZ=A[XX,XX]

scalar `i'_priv_cv=0
forvalues xx=1(1)98 {
forvalues mm =1(1)98 {
scalar `i'_priv_cv=`i'_priv_cv+A[`mm',`xx']
}
}

* Public regressions
qui reg `i' MSA2-MSA99 age age2 male age_male age2_male income income2 dz_2-dz_30 Y2-Y7 if mcbs==1, robust
matrix A=e(V)
* Public coefficient estimates
scalar `i'_pe1=0
forvalues ZZ=2(1)99 {
scalar `i'_pe`ZZ'=_b[MSA`ZZ']
}
* Public coefficient variances
scalar `i'_pv1=0
for ZZ in num 2/99 \ XX in num 1/98: scalar `i'_pvZZ=A[XX,XX]
scalar `i'_pub_cv=0
forvalues xx=1(1)98 {
forvalues mm =1(1)98 {
scalar `i'_pub_cv=`i'_pub_cv+A[`mm',`xx']
}
}

drop dz* Y* mcbs MSA* 

forvalues JJ=1(1)99 {
gen `i'_MSA`JJ'=`i'_e`JJ'
gen `i'_MSA_v`JJ'=`i'_v`JJ'
}
forvalues JJ=1(1)99 {
gen `i'_MSA_pub`JJ'=`i'_pe`JJ' 
gen `i'_MSA_pub_v`JJ'=`i'_pv`JJ'
}

gen `i'_cov=`i'_priv_cv
gen `i'_pub_cov=`i'_pub_cv

keep `i'_MSA* `i'_cov `i'_pub_cov

duplicates drop
reshape long `i'_MSA `i'_MSA_pub `i'_MSA_v `i'_MSA_pub_v , i(`i'_cov `i'_pub_cov) j(msa)

cap append using "`rfedat'"
save "`rfedat'", replace
}


use "`rfedat'", clear

foreach i in no_hosp days_hosp outpat_vis rx_30de {

* Private
sum `i'_MSA
scalar `i'_sd=r(sd)
scalar `i'_v=r(sd)^2
sum `i'_MSA_v
scalar v`i'=r(mean)
sum `i'_cov
scalar `i'_samperr=v`i'-(r(mean)/(r(N)^2))
display `i'_samperr
scalar `i'_v_cor=`i'_v-`i'_samperr

* Public
qui sum `i'_MSA_pub
scalar `i'_pub_sd=r(sd)
scalar `i'_pub_v=r(sd)^2
qui sum `i'_MSA_pub_v
scalar v`i'_pub=r(mean)
qui sum `i'_pub_cov
scalar `i'_pub_samperr=v`i'_pub-(r(mean)/(r(N)^2))
display `i'_pub_samperr
scalar `i'_pub_v_cor=`i'_pub_v-`i'_pub_samperr

* Public private differences
scalar `i'_var_diff=`i'_pub_v-`i'_v
scalar `i'_var_diff_cor=`i'_pub_v_cor-`i'_v_cor

* Public private ratios
scalar `i'_var_rat=`i'_pub_v/`i'_v
scalar `i'_var_rat_cor=`i'_pub_v_cor/`i'_v_cor

preserve
foreach ss in `i'_v `i'_pub_v `i'_samperr `i'_pub_samperr `i'_v_cor `i'_pub_v_cor `i'_var_diff `i'_var_diff_cor `i'_var_rat `i'_var_rat_cor {
gen `ss'=`ss'
}

* Collapse to bootrap round variables
collapse (mean) `i'_v `i'_pub_v `i'_samperr `i'_pub_samperr `i'_v_cor `i'_pub_v_cor `i'_var_diff `i'_var_diff_cor `i'_var_rat `i'_var_rat_cor

* Append data
gen bootround=`z'
cap append using "`bootdat2'"
save "`bootdat2'", replace
restore
}
} 

use "`bootdat2'", clear
collapse (mean) no_hosp* days_hosp* outpat_vis* rx_30de*, by(bootround)

save bootdata_regression_utilization, replace 

foreach i in no_hosp days_hosp outpat_vis rx_30de {
sum `i'*

* Compute the standard errors for the differences and ratios
qui sum `i'_var_diff 
scalar `i'_diff_obs_se=r(sd)

qui sum `i'_var_diff_cor 
scalar `i'_diff_corr_se=r(sd)

qui sum `i'_var_rat 
scalar `i'_rat_obs_se=r(sd)

qui sum `i'_var_rat_cor
scalar `i'_rat_corr_se=r(sd)

matrix A_`i'=[`i'_diff_obs_se, `i'_diff_corr_se, `i'_rat_obs_se, `i'_rat_corr_se] 
}

matrix A_ut=[A_no_hosp \ A_days_hosp \ A_outpat_vis \ A_rx_30de]

matrix colnames A_ut= se_diff_obs se_diff_cor se_ratio_obs se_ratio_cor
matrix rownames A_ut=hospitalizations days outpat_visits scripts


* DISPLAY RESULTS
* Utilization
matrix list A_ut, format(%9.5fc)


